<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$routes->get('/index', 'Home::index');

$routes->get('register', 'Home::register');
$routes->get('login', 'Home::login');
$routes->post('/login', 'Login::auth');
$routes->post('/register', 'Home::post_register');
$routes->get('/members', 'Home::members');
$routes->get('/marketers', 'Home::marketers');
$routes->get('/logout', 'Login::logout');
$routes->get('/packages', 'Home::packages');
$routes->get('/transactions', 'Home::transactions');
$routes->get('/earnings', 'Home::earnings');
$routes->post('/earnings', 'Home::updatepaymentstatus');
$routes->get('/addproducts', 'Home::addproducts');
$routes->post('/addproducts', 'Home::addjournalpost');
$routes->get('/viewproducts', 'Home::viewproducts');
$routes->post('/marketers', 'Home::postdeposit');
$routes->get('/addnotification', 'Home::addnotification');
$routes->post('/addnotification', 'Home::addnotificationpost');
$routes->get('/deposit', 'Home::adddeposit');
$routes->post('/deposit', 'Home::adddepositpost');
$routes->get('/editmember', 'Home::editmember');
$routes->post('/editmember', 'Home::editmemberpost');
$routes->get('/withdraw', 'Home::withdraw');
$routes->post('/withdraw', 'Home::withdrawpost');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
